var SIMPLE_LIST_CLASS_NAME = "simpleList";
var SIMPLE_LIST_EVEN_ROW_CLASS_NAME = "simpleListEvenRow";
var SIMPLE_LIST_ODD_ROW_CLASS_NAME = "simpleListOddRow";
var SIMPLE_LIST_SELECTED_CLASS_NAME = "simpleListSelected";
var SIMPLE_LIST_ROW_CLASS_NAME = "simpleListRowContent";

function SimpleList(id, callback)
{
	this.listItems = new Array();
	this.listItemCount = 0;
	this.callback = callback;
	this.selectedItem = null;
	this.id = id;
	this.listElement = document.getElementById(id);
	this.listElement.className = SIMPLE_LIST_CLASS_NAME;
}

SimpleList.prototype.createItemId = function(id)
{
	return this.id + "__" + id;
}

SimpleList.prototype.addItem = function(id, title)
{
	if (this.listItems[id])
	{
		return false;
	}
	this.listItemCount++;
	var listItem = document.createElement("a");
	listItem.id = this.createItemId(id);
	listItem.href = "#";
	listItem.className = this.listItemCount % 2 == 0 ? SIMPLE_LIST_EVEN_ROW_CLASS_NAME : SIMPLE_LIST_ODD_ROW_CLASS_NAME;
	var rowContent = document.createElement("div");
	rowContent.className = SIMPLE_LIST_ROW_CLASS_NAME;
	rowContent.appendChild(document.createTextNode(title));
	listItem.appendChild(rowContent);
	
	var simpleList = this;
	listItem.onclick = function()
	{
		simpleList.setSelectedItem(id);
		simpleList.callback(id);
	};
	this.listItems[id] = listItem;
	this.listElement.appendChild(listItem);
	return true;
}

SimpleList.prototype.removeItem = function(id)
{
	var itemToDelete = this.listItems[id];
	if (!itemToDelete)
	{
		return false;
	}
	
	this.listElement.removeChild(itemToDelete);
	delete this.listItems[id];
	return true;
}

SimpleList.prototype.clearList = function()
{
	this.listItems = new Array();
	this.listItemCount = 0;
	this.selectedItem = null;
	Xml.removeAllChildren(this.listElement);
}

SimpleList.prototype.editItem = function(id, title)
{
	var itemToEdit = this.listItems[id];
	if (!itemToEdit)
	{
		return false;
	}
	
	itemToEdit.innerHTML = title;
	return true;
}

SimpleList.prototype.setSelectedItem = function(id)
{
	var listItem = document.getElementById(this.createItemId(id));
	
	if (!listItem)
	{
		return false;
	}
	
	if (this.selectedItem)
	{
		var selectedListItem = document.getElementById(this.createItemId(this.selectedItem));
		if (selectedListItem)
		{
			selectedListItem.className = selectedListItem.oldClassName;
		}
	}
	
	listItem.oldClassName = listItem.className;
	listItem.className = SIMPLE_LIST_SELECTED_CLASS_NAME;
	
	this.selectedItem = id;
	
	return true;
}

SimpleList.prototype.getSelectedItem = function()
{
	return this.selectedItem;
}

SimpleList.prototype.displayMessage = function(msg)
{
	this.clearList();
	var p = document.createElement("p");
	p.appendChild(document.createTextNode(msg));
	
	this.listElement.appendChild(p);
}